/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package actions;

import org.apache.struts2.util.*;
import javax.servlet.*;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.validator.annotations.*;
import modelo.GestionClientes;
@Validation
public class Registrar extends ActionSupport implements ServletContextAware{
    private String nombre;
    private String apellidos;
    private String password;
    private String usuario;
    private String email;
    ServletContext context;
    public String execute() throws Exception {
      String driver=context.getInitParameter("driver");
      String cadenaCon=context.getInitParameter("cadenaCon");
      GestionClientes gc=new GestionClientes(driver,cadenaCon);
      gc.registrar(nombre, apellidos, usuario, password, email);
      return "registrado";
    }
    //validación de cadena requerida y longitud
    //mínima para el password
    @RequiredStringValidator(message="debe introducir un password")
    @StringLengthFieldValidator(minLength="6",message="el password debe tener al menos 6 caracteres")
    public String getPassword() {
        return password;
    }
    public void setPassword(String password) {
        this.password = password;
    }
    public String getApellidos() {
        return apellidos;
    }
    public void setApellidos(String apellidos) {
        this.apellidos = apellidos;
    }
    //validación de cadena requerida y valor
    //válido para el email
    @RequiredStringValidator(message="debe introducir un email")
    @EmailValidator(message="dirección de email no válida")
    public String getEmail() {
        return email;
    }
    public void setEmail(String email) {
        this.email = email;
    }
    public String getNombre() {
        return nombre;
    }
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }
    //validación de cadena requerida para
    //el usuario
    @RequiredStringValidator(message="debe introducir un usuario")
    public String getUsuario() {
        return usuario;
    }
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }
    public void setServletContext(ServletContext context){
      this.context=context;

    }
}
